<div class="form-group">
    <label>Outlet name:</label>
    <select name="outlet_id" class="form-control selectpicker" data-size="7" data-live-search="true">
        <?php $__currentLoopData = $outlets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $outlet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($outlet->id); ?>" <?php echo e((isset($voucher) && $voucher->outlet_id == $outlet->id) ? 'selected' : ''); ?>><?php echo e($outlet->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

<div class="form-group">
    <label>Voucher name:</label>
    <input type="text" name="name" class="form-control" placeholder="Enter Voucher name" value="<?php echo e($voucher->name ?? ''); ?>" required/>
</div>

<div class="form-group">
    <label>Voucher code:</label>
    <input type="text" name="code" class="form-control" placeholder="Enter voucher code" value="<?php echo e($voucher->code ?? ''); ?>" required/>
</div>

<div class="form-group">
    <label>Discount Type:</label>
    <?php $discountType = $voucher->discount_type ?? ''; ?>
    <select name="discount_type" class="form-control selectpicker">
        <option <?php echo e($discountType == 'percentage' ? 'selected' : ''); ?> value="percentage">Percentage</option>
        <option <?php echo e($discountType == 'fixed' ? 'selected' : ''); ?> value="fixed">Fixed</option>
    </select>
</div>

<div class="form-group">
    <label>Discount value:</label>
    <input type="text" name="discount_value" class="form-control" placeholder="Enter discount value" value="<?php echo e($voucher->discount_value ?? ''); ?>" required/>
</div>

<div class="form-group">
    <label>Started at:</label>
    <input class="form-control" type="datetime-local" value="<?php echo e(isset($voucher->started_at) ? Carbon\Carbon::parse($voucher->started_at)->format('Y-m-d\TH:i') : ''); ?>" name="started_at" required/>
</div>

<div class="form-group">
    <label>Ended at:</label>
    <input class="form-control" type="datetime-local" value="<?php echo e(isset($voucher->ended_at) ? Carbon\Carbon::parse($voucher->started_at)->format('Y-m-d\TH:i') : ''); ?>" name="ended_at" required/>
</div>

<div class="form-group">
    <label>Image:</label>
    <div class="custom-file">
        <input type="file" class="custom-file-input" id="customFile"/>
        <label class="custom-file-label" for="customFile">Choose file</label>
    </div>
</div>

<div class="form-group">
    <label>Description:</label>
    <textarea name="description" class="form-control" rows="5" placeholder="Enter description"><?php echo e($voucher->description ?? ''); ?></textarea>
</div>

<div class="form-group">
    <div class="d-flex">
        <label class="col-form-label mr-3">Is Active:</label>
        <span class="switch switch-icon">
            <label>
            <input type="checkbox" name="is_active" <?php echo e((isset($voucher) && $voucher->is_active) ? 'checked' : ''); ?> />
            <span></span>
            </label>
        </span>
    </div>
</div>

<button type="submit" class="btn btn-primary mr-2">Submit</button>
<?php /**PATH /home/beec6812/public_html/beet_pos/resources/views/dashboard/promo/vouchers/partials/form.blade.php ENDPATH**/ ?>