<li class="menu-section">
    <h4 class="menu-text">{{ $label['label'] }}</h4>
    <i class="menu-icon ki ki-bold-more-hor icon-md"></i>
</li>

@foreach ($label['menus'] as $menu)
    <li class="menu-item menu-item-submenu" aria-haspopup="true" data-menu-toggle="hover">
        <a href="{{ $menu['url'] ?? 'javascript:;' }}" class="menu-link menu-toggle">
            <span class="svg-icon menu-icon">
                <i class="{{ $menu['icon'] }}"></i>
            </span>


            <span class="menu-text">{{ $menu['name'] }}</span>
            @if (! isset($menu['url']))
                <i class="menu-arrow"></i>
            @endif
        </a>

        @if (isset($menu['sub_menus']) && count($menu['sub_menus']))
            <div class="menu-submenu">
                <i class="menu-arrow"></i>
                <ul class="menu-subnav">
                    @foreach ($menu['sub_menus'] as $subMenu)
                        <li class="menu-item" aria-haspopup="true">
                            <a href="{{ $subMenu['url'] }}" class="menu-link">
                                <i class="menu-bullet menu-bullet-dot">
                                    <span></span>
                                </i>
                                <span class="menu-text">{{ $subMenu['name'] }}</span>
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
    </li>
@endforeach
