<?php

use Faker\Factory;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $owner = \App\Models\Owner::create([
            'name' => 'Owner 1',
            'email' => 'owner@beetpos.com'
        ]);

        $admin = \App\Models\User::create([
            'owner_id' => $owner->id,
            'full_name' => 'Admin',
            'email' => 'admin@beetpos.com',
            'password' => bcrypt('admin')
        ]);

        $store = \App\Models\Store::create([
            'owner_id' => $owner->id,
            'name' => 'Store 1',
            'business_category' => 'Retail',
            'province_id' => 1,
            'province_name' => 'DKI Jakarta',
            'city_id' => 2,
            'city_name' => 'Jakarta Barat',
            'district_id' => 3,
            'district_name' => 'Grogol Petamburan',
            'street_address' => 'Jalan abc',
            'postal_code' => 11460
        ]);

        $outletPusat = \App\Models\Outlet::create([
            'store_id' => $store->id,
            'name' => 'Outlet Pusat',
            'address' => 'Alamat...'
        ]);

        $faker = Faker\Factory::create();
        for ($i = 0; $i < 5; $i++) {
            $user = \App\Models\User::create([
                'owner_id' => $owner->id,
                'full_name' => $faker->name,
                'email' => $faker->safeEmail,
                'password' => bcrypt('password')
            ]);

            $outlet = \App\Models\Outlet::create([
                'store_id' => $store->id,
                'name' => 'Outlet ' . ($i + 1),
                'address' => 'Alamat...'
            ]);

            $categoryName = $faker->name;
            $category = \App\Models\ProductCategory::create([
                'store_id' => $store->id,
                'outlet_id' => $outlet->id,
                'name' => $categoryName
            ]);

            $productName = $faker->name;
            \App\Models\Product::create([
                'store_id' => $store->id,
                'outlet_id' => $outlet->id,
                'product_category_id' => $category->id,
                'name' => $productName,
                'price' => 100000,
                'stock' => 100,
                'is_manage_stock' => true
            ]);

            $customer = \App\Models\Customer::create([
                'full_name' => $faker->name,
                'email' => $faker->safeEmail,
                'phone_number' => '0811',
                'address' => 'Address'
            ]);
        }

        foreach (\App\Models\User::all() as $user) {
            foreach (\App\Models\Outlet::all() as $outlet) {
                \App\Models\UserOutlet::create([
                    'user_id' => $user->id,
                    'store_id' => $outlet->store_id,
                    'outlet_id' => $outlet->id
                ]);
            }
        }
    }
}
