<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductInventoryStockTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_inventory_stock_transfers', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('from_store_id');
            $table->foreign('from_store_id')->references('id')->on('stores')->onDelete('cascade');

            $table->unsignedBigInteger('to_store_id');
            $table->foreign('to_store_id')->references('id')->on('stores')->onDelete('cascade');

            $table->date('date')->nullable();
            $table->string('email')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_inventory_stock_transfers');
    }
}
