<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductInventoryStockEntryDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_inventory_stock_entry_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('store_id')->constrained()->onDelete('cascade');
            $table->foreignId('outlet_id')->constrained()->onDelete('cascade');
            $table->foreignId('product_inventory_stock_entry_id')->constrained()->onDelete('cascade')->index('product_inventory_stock_entry_id_foreigh');
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->integer('amount')->nullable();
            $table->double('purchase_price_per_unit')->nullable();
            $table->double('total_purchase_price')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_inventory_stock_entry_details');
    }
}
