<?php

namespace App\Http\Controllers\Dashboard\Discount;

use App\Http\Controllers\Controller;
use App\Models\Outlet;
use App\Models\Voucher;
use Illuminate\Http\Request;

class VoucherController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = 'Voucher';
        $data['voucher'] = Voucher::latest()->get();

        return view('dashboard.promo.vouchers.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['title'] = 'Create Voucher';
        $data['outlets'] = Outlet::all();

        return view('dashboard.promo.vouchers.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $inputs = $request->except('is_active');
        $inputs['is_active'] = ! is_null(request('is_active')) ? true : false;

        Voucher::create($inputs);

        return redirect(route('dashboard.vouchers.index'))->with([
            'success' => 'Success add new record'
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['title'] = 'Edit Voucher';
        $data['voucher'] = Voucher::findOrFail($id);
        $data['outlets'] = Outlet::all();

        return view('dashboard.promo.vouchers.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $inputs = $request->except('is_active');
        $inputs['is_active'] = ! is_null(request('is_active')) ? true : false;

        Voucher::findOrFail($id)->update($inputs);

        return redirect(route('dashboard.vouchers.index'))->with([
            'fail' => 'Success update record'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Voucher::findOrFail($id)->delete();

        return response()->json(['code' => 200]);
    }
}
